/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.io.File;

public class FileBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String TRACE_MASKT = "XLOGDBFT";
    private static final String TRACE_MASKF = "XLOGDBFF";
    private static final String TRACE_MASKD = "XLOGDBFD";
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    public static final String FILE_NAME = "fileName";
    public static final String AUIML_FILE_PANEL = "FilePanel";
    public static final String AUIML_SAVE_NOTE = "SaveFileNoteLabel";
    public static final String AUIML_FILE_EDIT_LABEL = "FileEdit";
    private String _fileNamePanel;
    private String m_sFileEdit;

    public String getFileEdit() {
        return this.m_sFileEdit;
    }

    public void setFileNamePanel(String fileNamePanel) {
        this._fileNamePanel = fileNamePanel;
    }

    public void setFileEdit(String s) throws IllegalUserDataException {
        this.m_sFileEdit = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void prepare() {
        if (this._fileNamePanel.equals("FileNamePanelRead")) {
            LocalizableText lPanelTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.filenameread.title");
            this.userTaskManager.setCaptionText(AUIML_FILE_PANEL, lPanelTitle.toString());
            this.userTaskManager.setShown(AUIML_SAVE_NOTE, false);
        }
    }

    public void save() {
    }

    public void load() {
        this.m_sFileEdit = "";
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> FileBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            utm.storeElement(AUIML_FILE_EDIT_LABEL);
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "command = " + command);
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", this._fileNamePanel);
            if (command.equals(BUTTON_OK)) {
                Trace.trace(TRACE_MASKF, "Type in filename - OK button selected");
                String fileName = this.getFileEdit();
                if (fileName == null || fileName.length() == 0 || fileName.endsWith(File.separator)) {
                    Trace.trace(TRACE_MASKF, "FileBean - file name was not entered.");
                    BaseMessageText myMess = new BaseMessageText("LOGENFILE");
                    LocalizableText lStrTitle = null;
                    lStrTitle = this._fileNamePanel.equals("FileNamePanelRead") ? new LocalizableText(BaseTextBundle.getBundleName(), "logd.filenameread.title") : new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.title");
                    CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    Trace.trace(TRACE_MASKF, "File name selected=" + fileName);
                    request.setData(FILE_NAME, fileName);
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
            Trace.trace(TRACE_MASKT, "<- FileBean.panelAction()");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in FileBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1304, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
    }
}

